/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.Interval;
import ibm.nways.analysis.dpEngine.InvalidScheduleTypeException;
import ibm.nways.analysis.dpEngine.InvalidTimeException;
import ibm.nways.analysis.dpEngine.Scheduler;
import java.io.Serializable;
import java.util.Vector;

public class Daily
implements Serializable {
    private Vector intervals;
    private Scheduler scheduler;
    public static final Boolean NORMAL = new Boolean(true);

    public Daily() {
        this.initialize(null, NORMAL);
    }

    public Daily(Object object) {
        this.initialize(null, object);
    }

    public Daily(Scheduler scheduler, Object object) {
        this.initialize(scheduler, object);
    }

    private void initialize(Scheduler scheduler, Object object) {
        this.intervals = new Vector();
        this.scheduler = scheduler;
        try {
            this.intervals.addElement(new Interval(object, 0, 0, 23, 59));
            return;
        }
        catch (InvalidTimeException invalidTimeException) {
            System.out.println("Can't initialize interval for whole day");
            return;
        }
    }

    public void activateSchedule(Scheduler scheduler) {
        this.scheduler = scheduler;
        try {
            scheduler.updateSchedule(this.intervals);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected Vector retrieveIntervals() {
        return this.intervals;
    }

    public Vector getIntervals() {
        Vector<Interval> vector = new Vector<Interval>();
        int n = this.intervals.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(new Interval((Interval)this.intervals.elementAt(n2)));
            ++n2;
        }
        return vector;
    }

    public void addIntervals(Vector vector) throws InvalidScheduleTypeException, InvalidTimeException {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.addInterval((Interval)vector.elementAt(n2));
            ++n2;
        }
    }

    public void addInterval(Interval interval) throws InvalidScheduleTypeException, InvalidTimeException {
        Interval interval2 = new Interval(interval);
        int n = this.intervals.size();
        int n2 = 0;
        block0: while (n2 < n) {
            Interval interval3 = (Interval)this.intervals.elementAt(n2);
            if (interval3.begin <= interval.begin && interval3.end >= interval.end) {
                if (interval3.state.equals(interval.state)) break;
                if (interval3.begin == interval.begin) {
                    interval3.begin = Interval.nextMinute(interval2.end);
                    this.intervals.insertElementAt(interval2, n2);
                    break;
                }
                if (interval3.end == interval.end) {
                    interval3.end = Interval.previousMinute(interval2.begin);
                    this.intervals.insertElementAt(interval2, n2 + 1);
                    break;
                }
                Interval interval4 = new Interval(interval3.state, Interval.nextMinute(interval2.end), interval3.end);
                interval3.end = Interval.previousMinute(interval2.begin);
                this.intervals.insertElementAt(interval2, n2 + 1);
                this.intervals.insertElementAt(interval4, n2 + 2);
                break;
            }
            if (interval3.begin <= interval2.begin && interval3.end >= interval2.begin) {
                int n3 = n2 + 1;
                while (n3 < n) {
                    Interval interval5 = (Interval)this.intervals.elementAt(n3);
                    if (interval5.end >= interval2.end) {
                        if (!interval3.state.equals(interval2.state) && !interval5.state.equals(interval2.state)) {
                            interval3.end = Interval.previousMinute(interval2.begin);
                            interval5.begin = Interval.nextMinute(interval2.end);
                            this.intervals.insertElementAt(interval2, n3);
                        } else if (interval2.state.equals(interval3.state)) {
                            interval3.end = interval2.end;
                            interval5.begin = Interval.nextMinute(interval2.end);
                        } else {
                            interval3.end = Interval.previousMinute(interval2.begin);
                            interval5.begin = interval2.begin;
                        }
                        int n4 = 0;
                        while (n4 < n3 - n2 - 1) {
                            this.intervals.removeElementAt(n2 + 1);
                            ++n4;
                        }
                        break block0;
                    }
                    ++n3;
                }
                break;
            }
            ++n2;
        }
        if (this.scheduler != null) {
            this.scheduler.updateSchedule(this.intervals);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.intervals.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Interval)this.intervals.elementAt(n2)).toString());
            ++n2;
        }
        return stringBuffer.toString();
    }
}

